%% Zurich SPM Course 2016
% Practical session on Preprocessing
% Authors: Maya Schneebeli, Jakob Heinzle
% Tutor: Lars Kasper
%
% The recipe for preprocessing.
% This is a rough guide for how to proceed during the tutorial and can help you, if at home you want to
% redo the tutorial once more. You do not need to go through this before the tutorial. We will do it together.
%
%
%% Step by step instructions:
%
% Preparation for the session:
%
% 1. Open Matlab, add the spm folder to your path and go to the folder that
% contains the material for the preprocessing session. 
%   On the demo computer,
%   this folder is E:\DemoDataset\SPM2016\PREPRO_tutorial.
%
% 2. Before we start, delete all .mat files in the RawEPI folder
%   cd RawEpi
%   delete('sM03953_0005*.mat')
%
% 3. Change the tutorialPath variable in ZHSPM_face_rep_spm12_prepro to where
% you put the face_rep folder
%
% 4. Also open on your computer the SPM manual on page 243.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% 1.) Some basic commands:
% Let's first look at some data and see how one can select data with SPM.
% Open SPM for fMRI by typing in your fNamesmatlab command:
%
spm fmri
%
%% Try the following commands and see what you get:
%
[ver,rel]=spm('ver');
%
%% Reading MRI data into Matlab:
% In Matlab, go to the folder RawEPI in the data folder of the tutorial.
% Then type:
%
fNames = spm_select('FPList', pwd, '^sM.*\.img$');
%
%
%% spm_select is a very useful function, type

help spm_select

% to get more information, e.g. on how to load 4D nifti files.

%% Now, lets load some data, lets start with the first functional volume.

hdr = spm_vol(fNames(1,:));
%%
% This is the so called hdr, with all the information about your MR images.
% You can now load the data.
%
X = spm_read_vols(hdr);
%
% And look at it (e.g. at plane number 12 in Z-direction):
%%
figure('Name', 'Slice 12');
imagesc(squeeze(X(:,:,12)));
axis ij
axis image
axis off
colormap gray;
%
%% If you want to load all data:
%
hdr = spm_vol(fNames);
X = spm_read_vols(hdr);
%
% And then plot the timeseries of a voxel, e.g.
%
figure('Name', 'TimeSeries Voxel 14,30,12');
plot(squeeze(X(14,30,12,:)));

%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% 2.) Preprocessing step by step:
% Ok, now lets turn to the real preprocessing and go through it, step by step.
% We will first go through the steps by hand, following the tutorial, but taking some shortcuts
% to save time.
%
% -- Slice Timing --
% We start with slice-timing correction, which we do before realignment.
%
% Follow the instructions in section 31.1.3 of the SPM manual. Use a filter
% ^sM.*.img instead of the one suggested.
%
% Save the batch to your batches folder with the name 01_PREPRO_SliceTime.mat,
% and save script and batch with the name 01_PREPRO_SliceTime.m
% Now run it by clicking on the green arrow.
%
%% Let's see what this has done to the voxel time courses and first load files.
%
sfNames = spm_select('FPList', pwd, '^sM.*\.img$');
shdr=spm_vol(sfNames);
sX=spm_read_vols(shdr);
asfNames = spm_select('FPList', pwd, '^asM.*\.img$');
ashdr=spm_vol(asfNames);
asX=spm_read_vols(ashdr);
%
% And then plot two time courses in a new figure, one from the top of the brian, one from the middle.
%
h=figure;
subplot(2,1,1);
plot(squeeze(sX(31,26,22,:)),'b')
hold on;
plot(squeeze(asX(31,26,22,:)),'--r')
subplot(2,1,2);
plot(squeeze(sX(14,30,12,:))),'b';
hold on;
plot(squeeze(asX(14,30,12,:)),'--r');
figure(h)
%
%
%% -- Realignment --
% We next want to realign the functional images. This time we go a slightly
% different way. Run the function ZHSPM_face_rep_spm12_prepro.m.
% This will create a batch for SPM and open it in an interactive window.
% At this point, we do not want to run the entire script, but just look at the second step, i.e.
% realignment. To do that, write in your Matlab Command Window
run ZHSPM_face_rep_spm12_prepro
spm_jobman('interactive',matlabbatch(2));
%
% We can now look at the realignment parameters in the batch editor and briefly discuss them.
%
% Let's save again the batch and the script as 02_PREPRO_Realign.
% Then, we run the realignment by pressing the green arrow.
%% Alternatively, you can run it by typing
%
spm_jobman('run',matlabbatch(2));
%
%% Wait until SPM is done. Are there any questions?
%
% Lets now go and see, whether realignment has worked.
% Go to check reg on the SPM menu and select the first and last of the sM*.img,
% and the first and the last of the rasM*.img.
%
% Look at the last one and see, whether you can see any improvement in its registration to the first one.
% The data was already very good, so there is not much to see, here.
%
% We can also look at the movement trajectories in the file rp*.txt.
% Load the file and plot it.
%
% (The next one is not needed, but could be done, if there is time. Move to coregister)
%
% Now, let's look at the last images only, but look at sM*.img, asM*.img and ras*.img. What do you observe?
%
% You can also call checkreg from the command line. That can be handy, if you want to automatically look at some specific plots.
%
 	spm_check_registration(char({'sM03953_0005_0356.img';'asM03953_0005_0356.img';'rasM03953_0005_0356.img'}));
%
%
%% -- Coregister --
% Now, lets coregister the anatomical image to the mean of the functionals.
%
spm_jobman('interactive',matlabbatch(3));
%
% Now save the batch (03_PREPRO_Coregister).
% Before we run, let's have a look at the two images we want to coregister. See which they are and open them with checkreg.
%
% Now let's run the script.
% Have a look at the output SPM gives us.
%
% Check again in checkreg the two images we have coregistered.
%
%
%% -- Segmentation and normalization --
% Next, we call the elements 4 to 6 of the matlabbatch together
%
spm_jobman('interactive',matlabbatch(4:6));
%
% What are the parameters for segmentation?
% Which files do we use?
% Let's have a look at the tissue probability maps.
%
% Do check reg, then go to the subfolder tpm within your spm (code) folder.
% Select the 6 tissue probability maps and have a look at them.
% Hint, to see all 6 maps, write 1:8 in the field below Filter in the "Select Images" window.
%
% Once segmentation is done, the other two batches use the estimated transformation y_*.mat to
% transform images to the normalized MNI space.
%
% Let's save again (04_PREPRO_SegmentNormalize) and run the script.
%
% Use check reg to see whether the normalized images w*.img are aligned with the SPM templates (MNI space).
%
% (We could also run matlabbatch(7) which normalized the resliced images ras*.mat, but this is not needed.)
%
%% -- Smoothing --
% Finally, we smooth the data. Load the batch for that.
%
spm_jobman('interactive',matlabbatch(8));
%
% Discuss parameters.
% Again, save the batch as 05_PREPRO_Smooth and run.
%
% That's it, we are done with preprocessing of one subject.
%
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% 3.) Addons, if we have time to do them.
% -- Dependencies --
% It is possible to define dependencies in a batch, so that SPM automatically handels all filenames to
% take the results of previous steps within the same batch.
% Load the complete matlabbatch
%
spm_jobman('interactive',matlabbatch)
%
% and try to replace paths with dependencies, whenever possible.
%
% If you are done, save the batch script to PREPRO_Dependencies.
% Have a look at the script and try to understand dependencies - that's sometimes quite difficult.
% So be aware when you start changing the script. Often it is easier to have paths coded explicitly.
