% Copyright (C) 2014-2015 Wellcome Trust Centre for Neuroimaging

% Guillaume Flandin
% $Id: face_rep_spm12_batch.m 17 2015-03-06 11:24:19Z guillaume $
% adapted by JH for the needs of the SPM tutorial on Preprocessing

% Set the path to the directory that you will use for the tutorial.
% !!! needs to be changed individually !!!
tutorialPath='/Users/kasperla/Dropbox/SeminarsEducational/MethodsModelsfMRI/2016/Preprocessing/Practicals';

% Directory containing Face data 
%--------------------------------------------------------------------------
data_path = fullfile(tutorialPath,'face_rep'); 


% Initialise SPM
%--------------------------------------------------------------------------
spm('Defaults','fMRI');
spm_jobman('initcfg');
% spm_get_defaults('cmdline',true);

% remove all .mat files that come with the RawEPI
cd(fullfile(data_path,'RawEPI'));
delete('sM03953_0005*.mat')

% Change working directory (useful for PostScript (.ps) files only)
%--------------------------------------------------------------------------
clear matlabbatch
matlabbatch{1}.cfg_basicio.file_dir.dir_ops.cfg_cd.dir = cellstr(data_path);
spm_jobman('run',matlabbatch);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% SPATIAL PREPROCESSING
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

clear matlabbatch

% Select functional and structural scans
%--------------------------------------------------------------------------
f = spm_select('FPList', fullfile(data_path,'RawEPI'), '^sM.*\.img$');
a = spm_select('FPList', fullfile(data_path,'Structural'), '^sM.*\.img$');


% Slice Timing Correction
%--------------------------------------------------------------------------
matlabbatch{1}.spm.temporal.st.scans{1} = cellstr(f);
matlabbatch{1}.spm.temporal.st.nslices = 24;
matlabbatch{1}.spm.temporal.st.tr = 2;
matlabbatch{1}.spm.temporal.st.ta = 2-2/24;
matlabbatch{1}.spm.temporal.st.so = 24:-1:1;
matlabbatch{1}.spm.temporal.st.refslice = 12;

% Realign
%--------------------------------------------------------------------------
matlabbatch{2}.spm.spatial.realign.estwrite.data{1} = cellstr(spm_file(f,'prefix','a'));

% Coregister
%--------------------------------------------------------------------------
matlabbatch{3}.spm.spatial.coreg.estimate.ref    = cellstr(spm_file(f(1,:),'prefix','meana'));
matlabbatch{3}.spm.spatial.coreg.estimate.source = cellstr(a);

% Segment
%--------------------------------------------------------------------------
matlabbatch{4}.spm.spatial.preproc.channel.vols  = cellstr(a);
matlabbatch{4}.spm.spatial.preproc.channel.write = [1 1];
matlabbatch{4}.spm.spatial.preproc.warp.write    = [1 1];

% Normalise: Write
%--------------------------------------------------------------------------
matlabbatch{5}.spm.spatial.normalise.write.subj.def      = cellstr(spm_file(a,'prefix','y_','ext','nii'));
matlabbatch{5}.spm.spatial.normalise.write.subj.resample = cellstr(spm_file(f,'prefix','a'));
matlabbatch{5}.spm.spatial.normalise.write.woptions.vox  = [3 3 3];

matlabbatch{6}.spm.spatial.normalise.write.subj.def      = cellstr(spm_file(a,'prefix','y_','ext','nii'));
matlabbatch{6}.spm.spatial.normalise.write.subj.resample = cellstr(spm_file(a,'prefix','m','ext','nii'));
matlabbatch{6}.spm.spatial.normalise.write.woptions.vox  = [1 1 1];

matlabbatch{7}.spm.spatial.normalise.write.subj.def      = cellstr(spm_file(a,'prefix','y_','ext','nii'));
matlabbatch{7}.spm.spatial.normalise.write.subj.resample = cellstr(char(spm_file(f,'prefix','ra'),spm_file(f(1,:),'prefix','meana')));
matlabbatch{7}.spm.spatial.normalise.write.woptions.vox  = [3 3 3];

% Smooth
%--------------------------------------------------------------------------
matlabbatch{8}.spm.spatial.smooth.data = cellstr(spm_file(f,'prefix','wa'));
matlabbatch{8}.spm.spatial.smooth.fwhm = [8 8 8];
matlabbatch{8}.spm.spatial.smooth.prefix = 's8';

%save('face_batch_preprocessing.mat','matlabbatch');
spm_jobman('interactive',matlabbatch);

