function teach_check_behav(subjNum,myDataFolder)

% teach_check_behav(subjNum,doRun) performs/sets up a preprocessing pipeline. 
% Inputs:   subjNum -  number of subject (1 to 4)
%           myDataFolder - path to the folder where the individual subject
%                       folders are located
%
% Outputs: matlabbatch  -  batch containing information about analysis.
% 
% Created: Oct 2019, Sandra Iglesias, Translational neuromodeling Unit, IBT
% University and ETH Zrich

if nargin < 2
myDataFolder = fullfile('E:','Documents_E','Seminars','M&M_Mantelstudium_2019','Tutorial','DataStudents');
end

if ~(exist(myDataFolder)) % Check whether data folder exists.
    error('Could not find specified data folder')
end

%% plot raw data:
runrawName{1} = fullfile(myDataFolder,sprintf('Sub%02.0f',subjNum),'behav/BehavRun01.mat');
runrawName{2} = fullfile(myDataFolder,sprintf('Sub%02.0f',subjNum),'behav/BehavRun02.mat');

rawData1 = load(runrawName{1});
rawData2 = load(runrawName{2});

%% plot raw data:
runrawName{1} = fullfile(myDataFolder,sprintf('Sub%02.0f',subjNum),'behav/BehavRun01.mat');
runrawName{2} = fullfile(myDataFolder,sprintf('Sub%02.0f',subjNum),'behav/BehavRun02.mat');

rawData1 = load(runrawName{1});
rawData2 = load(runrawName{2});

% plot data of session one
figure('Color', [1 1 1]);
Y1 = ones(1,length(rawData1.startTrial));
subplot(2,1,1);plot(rawData1.startTrial,Y1,'o');
hold on;
Y11 = 0.9*(ones(1,length(rawData1.tButtonPress)));
plot(rawData1.tButtonPress,Y11,'o','Color','r'); 
ylim([0.8 1.1]);
legend('trial onsets (blue)','button press onsets (red)')
xlabel('Session 1');

% plot data of session two
Y2 = ones(1,length(rawData2.startTrial));
subplot(2,1,2);plot(rawData2.startTrial,Y2,'o');
hold on;
Y21 = 0.9*(ones(1,length(rawData2.tButtonPress)));
plot(rawData2.tButtonPress,Y21,'o','Color','r'); 
ylim([0.8 1.1]);
legend('trial onsets (blue)','button press onsets (red)')
xlabel('Session 2');

clear Y1; clear Y11; clear Y2; clear Y21;

%% plot behavioural data of both sessions;
% load onsets of responses and onsets of visual presentation:
runName{1} = fullfile(myDataFolder,sprintf('Sub%02.0f',subjNum),'behav/BehaviorSummary01.mat');
runName{2} = fullfile(myDataFolder,sprintf('Sub%02.0f',subjNum),'behav/BehaviorSummary02.mat');

sumData1 = load(runName{1});
sumData2 = load(runName{2});

% plot data of session one
figure('Color', [1 1 1]);
Y1 = ones(1,length(sumData1.tLeftStim));
subplot(2,1,1);plot(sumData1.tLeftStim,Y1,'o','Color','b');
hold on;
plot(sumData1.tRightStim,Y1,'o','Color','c');
Y11 = 0.9*(ones(1,length(sumData1.tLeftPress)));
Y12 = 0.9*(ones(1,length(sumData1.tRightPress)));
plot(sumData1.tLeftPress,Y11,'o','Color','r'); 
plot(sumData1.tRightPress,Y12,'o','Color','m'); 
ylim([0.8 1.1]);
legend('left stimuli (blue)','right stimuli (cyan)','left button press (red)','right button press (magenta)')
xlabel('Session 1');

% plot data of session two
Y2 = ones(1,length(sumData2.tLeftStim));
subplot(2,1,2);plot(sumData2.tLeftStim,Y2,'o','Color','b');
hold on;
plot(sumData2.tRightStim,Y2,'o','Color','c');
Y21 = 0.9*(ones(1,length(sumData2.tLeftPress)));
Y22 = 0.9*(ones(1,length(sumData2.tRightPress)));
plot(sumData2.tLeftPress,Y21,'o','Color','r'); 
plot(sumData2.tRightPress,Y22,'o','Color','m'); 
ylim([0.8 1.1]);
legend('left stimuli (blue)','right stimuli (cyan)','left button press (red)','right button press (magenta)')
xlabel('Session 2');

end